/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.event;

import com.nyfaria.numismaticoverhaul.villagers.data.NumismaticVillagerTradesRegistry;
import com.nyfaria.numismaticoverhaul.villagers.data.VillagerTradesResourceListener;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="numismaticoverhaul", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonForgeEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35585_) {
            return;
        }
        for (int i = 1; i <= event.getTrades().size(); ++i) {
            NumismaticVillagerTradesRegistry.registerFabricVillagerTrades(event.getType(), i, (List)event.getTrades().get(i));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWanderingTrades(WandererTradesEvent event) {
        int i;
        for (i = 0; i < event.getGenericTrades().size(); ++i) {
            NumismaticVillagerTradesRegistry.registerWanderingTraderTrade(i, (VillagerTrades.ItemListing)event.getGenericTrades().get(i));
        }
        for (i = 0; i < event.getRareTrades().size(); ++i) {
            NumismaticVillagerTradesRegistry.registerWanderingTraderTrade(i, (VillagerTrades.ItemListing)event.getRareTrades().get(i));
        }
    }

    @SubscribeEvent
    public static void reloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new VillagerTradesResourceListener());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void doCommonVillagerTrades(ServerStartedEvent event) {
        Tuple<HashMap<VillagerProfession, Int2ObjectOpenHashMap<VillagerTrades.ItemListing[]>>, Int2ObjectOpenHashMap<VillagerTrades.ItemListing[]>> registry = NumismaticVillagerTradesRegistry.getRegistryForLoading();
        VillagerTrades.f_35627_.putAll((Map)registry.m_14418_());
        NumismaticVillagerTradesRegistry.wrapModVillagers();
    }
}

